#include <stdio.h>
#include <stdlib.h>

int* transform_to_palindrome(const int* arr, int n, int* sum_of_differences) {
    int* palindrome_list = (int*)malloc(n * sizeof(int));

    *sum_of_differences = 0;

    int i = 0;
    int j = n - 1;

    while (i <= j) {
        int left_val = arr[i];
        int right_val = arr[j];

        int difference;
        int chosen_val;

        if (i == j) {
            chosen_val = left_val;
            difference = 0;
        } else if (left_val <= right_val) {
            chosen_val = left_val;
            difference = right_val - left_val;
        } else {
            chosen_val = right_val;
            difference = left_val - right_val;
        }

        palindrome_list[i] = chosen_val;
        if (i != j) {
            palindrome_list[j] = chosen_val;
        }

        *sum_of_differences += difference;

        i++;
        j--;
    }

    return palindrome_list;
}

int main() {
    int n;

    scanf("%d", &n);

    int* arr = (int*)malloc(n * sizeof(int));

    for (int i = 0; i < n; i++) {
      scanf("%d", &arr[i]);
    }

    int sum_diff;
    int* pal_list = transform_to_palindrome(arr, n, &sum_diff);
    free(arr);

    printf("%d\n", sum_diff);

    if (pal_list) {
        for (int k = 0; k < n; k++) {
            printf("%d", pal_list[k]);
            if (k < n - 1) {
                printf(" ");
            }
        }
        printf("\n");
        free(pal_list);
    }

    return 0;
}