# Ucitavanje ulaza za K, D i N
maks_klijenata = int(input("Unesite maksimalan broj klijenata koje Sofija može da zastupa u jednom trenutku (K): "))
dani_za_slucaj = int(input("Unesite broj dana potreban za rešavanje slucaja jednog klijenta (D): "))
ukupno_dana = int(input("Unesite broj dana za koje želite da pratite klijente (N): "))

# Ucitavanje broja zahteva po danima
zahtevi_po_danu = [0] * ukupno_dana
for i in range(ukupno_dana):
    zahtevi_po_danu[i] = int(input(f"Unesite broj novih zahteva za dan {i+1}: "))

# Lista za pracenje koliko novih klijenata je prihvaceno D dana ranije
# Ovo služi da znamo koliko mesta ce biti oslobodeno
zavrseni_klijenti_po_danu = [0] * ukupno_dana

ukupan_broj_klijenata = 0
trenutno_aktivni = 0

for dan in range(ukupno_dana):
    # Oslobadanje mesta za klijente koji su završili svoj slucaj pre D dana
    if dan >= dani_za_slucaj:
        trenutno_aktivni -= zavrseni_klijenti_po_danu[dan - dani_za_slucaj]

    # Koliko novih klijenata Sofija može da prihvati danas
    slobodna_mesta = maks_klijenata - trenutno_aktivni
    prihvaceni_danas = zahtevi_po_danu[dan]
    if prihvaceni_danas > slobodna_mesta:
        prihvaceni_danas = slobodna_mesta

    # Ažuriranje aktivnih klijenata
    trenutno_aktivni += prihvaceni_danas
    zavrseni_klijenti_po_danu[dan] = prihvaceni_danas
    ukupan_broj_klijenata += prihvaceni_danas

print(f"Ukupan broj klijenata koje Sofija zastupa: {ukupan_broj_klijenata}")