import math

def resi_zadatak_precizno(iznos_marina, iznos_nadja, iznos_Petar):
    # Sve osobe ukljucujuci Vlada
    svi_ljudi = ['M', 'N', 'P', 'V']
    iznosi_placeni = {'M': iznos_marina, 'N': iznos_nadja, 'P': iznos_petar, 'V': 0.0}

    ukupan_racun = sum(iznosi_placeni.values())
    broj_ljudi = len (svi_ljudi)
    # Prosecan iznos koji svako treba da snosi
    deo_po_osobi = ukupan_racun / broj_ljudi

    # Izracunavamo koliko je svako u plusu ili minusu u odnosu na prosek
    # (Pozitivna razlika znaci da su pretplatili i da im se duguje)
    stanja = {ime: iznos - deo_po_osobi for ime, iznos in iznosi_placeni.items()}

    # Vlad nije ništa platio, njegovo stanje je negativno, on duguje drugima.
    # Zanima nas kome Vlad duguje najviše, tj. ko je najviše u "plusu".

    # Pronalazimo osobu (slovo) sa najvecim pozitivnim stanjem
    # Izdvajamo samo one kojima se duguje (pozitivna strana) i Vladara (nije bitno)
    poverioci = {ime: stanje for ime, stanje in stanja.items()if stanje > 0}

    if not poverioci:
        return "Nema dugovanja" # Ovo se ne bi smelo desiti po uslovima zadatka

    # Nadi osobu sa najvecim iznosom koji joj se duguje
    osoba_kojoj_se_duguje_najviše = max(poverioci, key=poverioci.get)

    return osoba kojoj_se_duguje_najvise

    # Primer 1
    print(f"Rezultat za Primer 1: {resi_zadatak_precizno(10.02, 34.37, 17.9)}")
    # Primer 2
    print(f"Rezultat za Primer 2: {resi_zadatak_precizno(58.5, 12.43, 17.9)}")