def raspodela_cokolade(n, k):
    """
    Funkcija prima:
    n – ukupan broj redova cokolade
    k – broj redova koji je ostao Ceci

    Nešin deo je prvi deo, Ceca drugi deo.
    Drugi deo ima k redova, pa prvi deo automatski ima n - k redova.

    Funkcija vraca koliko redova ima Nešin deo.
    """
    # Provera validnosti podataka
    if not (1 <= n <= 10**9):
        raise ValueError("Broj redova n mora biti izmedju 1 i 10^9.")
    if not (1 <= k <= n):
        raise ValueError("Broj redova k mora biti izmedju 1 i n.")

    # Nešin deo = prvi deo = n - k
    nesin_deo = n - k
    return nesin_deo


# Glavni deo programa – unos podataka
try:
    # Ucitavanje dva broja iz jednog reda
    n, k = map(int, input("Unesi n i k: ").split())

    # Poziv funkcije
    rezultat = raspodela_cokolade(n, k)

    # Ispis rezultata
    print("Nešin deo ima", rezultat, "redova.")
except Exception as e:
    print("Greška:", e)