def calculate_age(jmbg):
    # today
    day_t, month_t, year_t = 15, 11, 2025

    # extract date from JMBG
    day = int(jmbg[0:2])
    month = int(jmbg[2:4])
    year_code = int(jmbg[4:7])

    # determine full birth year
    if 0 <= year_code <= 25:
        year = 2000 + year_code
    else:
        year = 1000 + year_code  # 1000–1999 ? 1900–1999

    # compute age
    age = year_t - year

    # birthday check
    if (month > month_t) or (month == month_t and day > day_t):
        age -= 1

    return age


# ----- main program -----
jmbg = input().strip()
print(calculate_age(jmbg))